/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.lua;

import com.opensr5.ConfigurationImage;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.config.generated.Fields;
import com.rusefi.core.preferences.storage.Node;
import com.rusefi.io.ConnectionStatusLogic;
import com.rusefi.io.LinkManager;
import com.rusefi.ui.MessagesPanel;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.lua.TextEditor;
import com.rusefi.ui.util.URLLabel;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.AnyCommand;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import neoe.formatter.lua.LuaFormatter;

public class LuaScriptPanel {
    private final UIContext context;
    private final JPanel mainPanel = new JPanel(new BorderLayout());
    private final AnyCommand command;
    private final TextEditor scriptText = new TextEditor();

    public LuaScriptPanel(UIContext context, Node config) {
        this.context = context;
        this.command = AnyCommand.createField(context, config, true, true);
        JPanel upperPanel = new JPanel(new FlowLayout(0, 5, 0));
        JButton writeButton = new JButton("Write to ECU");
        JButton resetButton = new JButton("Reset/Reload Lua");
        JButton formatButton = new JButton("Format");
        JButton burnButton = new JButton("Burn to ECU");
        MessagesPanel mp = new MessagesPanel(null, config);
        writeButton.addActionListener(e -> {
            this.write();
            mp.setPaused(false);
        });
        resetButton.addActionListener(e -> this.resetLua());
        formatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sourceCode = LuaScriptPanel.this.scriptText.getText();
                try {
                    String formatted = new LuaFormatter().format(sourceCode, new LuaFormatter.Env());
                    LuaScriptPanel.this.scriptText.setText(formatted);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        burnButton.addActionListener(e -> {
            LinkManager linkManager = context.getLinkManager();
            linkManager.submit(() -> {
                BinaryProtocol bp = linkManager.getCurrentStreamState();
                bp.burn();
            });
        });
        upperPanel.add(formatButton);
        upperPanel.add(writeButton);
        upperPanel.add(resetButton);
        upperPanel.add(burnButton);
        upperPanel.add(this.command.getContent());
        upperPanel.add(new URLLabel("Lua Wiki", "https://github.com/rusefi/rusefi/wiki/Lua-Scripting"));
        JPanel scriptPanel = new JPanel(new BorderLayout());
        scriptPanel.add((Component)this.scriptText.getControl(), "Center");
        JPanel messagesPanel = new JPanel(new BorderLayout());
        messagesPanel.add("North", mp.getButtonPanel());
        messagesPanel.add("Center", mp.getMessagesScroll());
        ConnectionStatusLogic.INSTANCE.addListener(isConnected -> SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LuaScriptPanel.this.readFromECU();
                }
                catch (Throwable e) {
                    System.out.println(e);
                }
            }
        }));
        JSplitPane centerPanel = new JSplitPane(1, scriptPanel, messagesPanel);
        this.mainPanel.add((Component)upperPanel, "North");
        this.mainPanel.add((Component)centerPanel, "Center");
        UiUtils.trueLayout(this.mainPanel);
        SwingUtilities.invokeLater(() -> centerPanel.setDividerLocation(centerPanel.getSize().width / 2));
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    public ActionListener getTabSelectedListener() {
        return e -> {
            if (this.command != null) {
                this.command.requestFocus();
            }
        };
    }

    void readFromECU() {
        BinaryProtocol bp = this.context.getLinkManager().getCurrentStreamState();
        if (bp == null) {
            this.scriptText.setText("No ECU located");
            return;
        }
        ConfigurationImage image = bp.getControllerConfiguration();
        if (image == null) {
            this.scriptText.setText("No configuration image");
            return;
        }
        ByteBuffer luaScriptBuffer = image.getByteBuffer(Fields.LUASCRIPT.getOffset(), 8000);
        byte[] scriptArr = new byte[8000];
        luaScriptBuffer.get(scriptArr);
        int i = LuaScriptPanel.findNullTerminator(scriptArr);
        this.scriptText.setText(new String(scriptArr, 0, i, StandardCharsets.US_ASCII));
    }

    private static int findNullTerminator(byte[] scriptArr) {
        int i;
        for (i = 0; i < scriptArr.length && scriptArr[i] != 0; ++i) {
        }
        return i;
    }

    void write() {
        String script = this.scriptText.getText();
        LinkManager linkManager = this.context.getLinkManager();
        linkManager.submit(() -> {
            int thisWrite;
            BinaryProtocol bp = linkManager.getCurrentStreamState();
            byte[] paddedScript = new byte[8000];
            byte[] scriptBytes = script.getBytes(StandardCharsets.US_ASCII);
            System.arraycopy(scriptBytes, 0, paddedScript, 0, scriptBytes.length);
            int idx = 0;
            do {
                int remaining = paddedScript.length - idx;
                thisWrite = Math.min(remaining, 750);
                bp.writeData(paddedScript, idx, Fields.LUASCRIPT.getOffset() + idx, thisWrite);
                idx += thisWrite;
            } while ((remaining -= thisWrite) > 0);
            this.resetLua();
        });
    }

    void resetLua() {
        this.context.getCommandQueue().write("luareset");
    }
}

