/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ConfigField;
import com.rusefi.ReaderState;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.ConfigurationConsumer;
import com.rusefi.output.FieldIterator;
import com.rusefi.output.FieldsStrategy;
import com.rusefi.output.JavaFieldsConsumer;
import java.io.IOException;

public class JavaSensorsConsumer
implements ConfigurationConsumer {
    public int sensorTsPosition;
    private final StringBuilder sb = new StringBuilder();

    @Override
    public void startFile() {
    }

    @Override
    public void endFile() throws IOException {
    }

    @Override
    public void handleEndStruct(ReaderState readerState, ConfigStructure structure) throws IOException {
        FieldsStrategy fieldsStrategy = new FieldsStrategy(){

            @Override
            public int writeOneField(FieldIterator iterator, String prefix, int tsPosition) {
                ConfigField configField = iterator.cf;
                ConfigField next = iterator.next;
                if (!configField.isBit()) {
                    JavaSensorsConsumer.this.sb.append(configField.getName()).append("(");
                    String string = configField.getCommentTemplated();
                    if (string == null || string.isEmpty()) {
                        string = JavaSensorsConsumer.quote(configField.getName());
                    } else if (string.charAt(0) != '\"') {
                        string = JavaSensorsConsumer.quote(string);
                    }
                    JavaSensorsConsumer.this.sb.append(string).append(", ");
                    JavaSensorsConsumer.this.sb.append("SensorCategory.SENSOR_INPUTS, ");
                    JavaSensorsConsumer.this.sb.append(JavaFieldsConsumer.getJavaType(configField.getElementSize())).append(", ");
                    JavaSensorsConsumer.this.sb.append(tsPosition).append(", ");
                    JavaSensorsConsumer.this.sb.append(configField.autoscaleSpecNumber()).append(", ");
                    JavaSensorsConsumer.this.sb.append(configField.getMin()).append(", ");
                    JavaSensorsConsumer.this.sb.append(configField.getMax()).append(", ");
                    JavaSensorsConsumer.this.sb.append(JavaSensorsConsumer.quote(configField.getUnits())).append(")");
                    JavaSensorsConsumer.this.sb.append(",");
                    JavaSensorsConsumer.this.sb.append("\n");
                }
                JavaSensorsConsumer.this.sensorTsPosition = tsPosition += configField.getSize(next);
                return tsPosition;
            }
        };
        fieldsStrategy.run(readerState, structure, this.sensorTsPosition);
    }

    public static String quote(String string) {
        return "\"" + string + "\"";
    }

    public String getContent() {
        return this.sb.toString();
    }
}

