/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.f4discovery;

import com.devexperts.logging.Logging;
import com.rusefi.IoUtil;
import com.rusefi.RusefiTestBase;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.enums.debug_mode_e;
import com.rusefi.enums.engine_type_e;
import com.rusefi.enums.trigger_type_e;
import com.rusefi.functional_tests.EcuTestHelper;
import org.junit.Assert;
import org.junit.Test;

public class PwmHardwareTest
extends RusefiTestBase {
    private static final Logging log = Logging.getLogging(PwmHardwareTest.class);
    private static final int FREQUENCY = 160;

    @Override
    protected boolean needsHardwareTriggerInput() {
        return true;
    }

    @Test
    public void scheduleBurnDoesNotAffectTriggerIssue2839() {
        this.ecu.setEngineType(engine_type_e.FORD_ASPIRE_1996);
        this.ecu.sendCommand(IoUtil.setTriggerType(trigger_type_e.TT_TOOTHED_WHEEL_60_2));
        this.ecu.sendCommand(IoUtil.getDisableCommand("self_stimulation"));
        this.ecu.sendCommand(IoUtil.getEnableCommand("ext_stimulation"));
        this.ecu.changeRpm(1200);
        this.nextChart();
        this.nextChart();
        int triggerErrors = (int)SensorCentral.getInstance().getValueSource(Sensor.totalTriggerErrorCounter).getValue();
        log.info("triggerErrors " + triggerErrors);
        for (int i = 0; i < 10; ++i) {
            this.ecu.sendCommand("burnconfig");
            BinaryProtocol.sleep(5000L);
        }
        int totalTriggerErrorsNow = (int)SensorCentral.getInstance().getValueSource(Sensor.totalTriggerErrorCounter).getValue();
        log.info("totalTriggerErrorsNow " + totalTriggerErrorsNow);
        Assert.assertEquals("totalTriggerErrorCounter", triggerErrors, totalTriggerErrorsNow);
    }

    @Test
    public void testIdlePin() {
        this.ecu.setEngineType(engine_type_e.FRANKENSO_MIATA_NA6_MAP);
        this.ecu.changeRpm(1000);
        this.ecu.sendCommand("set_trigger_simulator_pin 0 none");
        this.ecu.sendCommand("set_trigger_simulator_pin 1 none");
        this.ecu.sendCommand("set_idle_pin PD2");
        this.ecu.sendCommand("set_ignition_pin 1 none");
        this.ecu.sendCommand("set_ignition_pin 2 none");
        this.ecu.sendCommand("set_ignition_pin 3 none");
        this.ecu.sendCommand("set_trigger_input_pin 1 PA8");
        this.ecu.sendCommand("set debug_mode " + debug_mode_e.DBG_LOGIC_ANALYZER.ordinal());
        this.ecu.sendCommand("set idle_solenoid_freq 160");
        this.ecu.sendCommand("set_logic_input_pin 0 PA5");
        this.ecu.sendCommand("writeconfig");
        BinaryProtocol.sleep(2000L);
        this.ecu.sendCommand(IoUtil.getEnableCommand("self_stimulation"));
        BinaryProtocol.sleep(2000L);
        EcuTestHelper.assertSomewhatClose("Idle PWM freq", 160.0, SensorCentral.getInstance().getValue(Sensor.debugIntField1), 0.01);
    }
}

