/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.binaryprotocol.test;

import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.binaryprotocol.test.SandboxCommon;
import com.rusefi.io.LinkManager;
import com.rusefi.io.can.Elm327Connector;
import com.rusefi.io.can.Elm327IoStream;
import com.rusefi.io.serial.BaudRateHolder;
import com.rusefi.io.serial.SerialIoStream;
import java.io.IOException;

public class Elm327Sandbox {
    public static void main(String[] args) throws InterruptedException, IOException {
        BaudRateHolder.INSTANCE.baudRate = 38400;
        String serialPort = "COM7";
        Elm327Connector connector = new Elm327Connector(SerialIoStream.openPort(serialPort));
        boolean initConnection = connector.start(serialPort);
        if (!initConnection) {
            return;
        }
        Elm327IoStream tsStream = connector.getTsStream();
        IncomingDataBuffer dataBuffer = tsStream.getDataBuffer();
        System.out.println("Hello new ELM327 connection, pending=" + dataBuffer.getPendingCount());
        Elm327Connector.whyDoWeNeedToSleepBetweenCommands();
        LinkManager linkManager = new LinkManager();
        SandboxCommon.verifyCrcNoPending(tsStream, linkManager);
    }
}

