/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PerfTraceTool {
    private static final String ENUM_START_TAG = "enum_start_tag";
    private static final String ENUM_END_TAG = "enum_end_tag";
    private static final String EOL = "\r\n";

    public static void readPerfTrace(String inputFileName, String outputFileName, String topClassLine, String stringType) throws IOException {
        List<String> enumNames = PerfTraceTool.readEnums(inputFileName);
        System.out.println("Got enums: " + enumNames);
        PerfTraceTool.writeClass(outputFileName, enumNames, topClassLine, stringType);
    }

    private static void writeClass(String outputFileName, List<String> enumNames, String topClassLine, String stringType) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFileName));
        writer.write(topClassLine + EOL + EOL);
        writer.write("public class EnumNames {\r\n");
        writer.write("\t" + stringType + "[] TypeNames = {" + EOL);
        for (String enumValue : enumNames) {
            writer.write("\t\"" + enumValue + "\"," + EOL);
        }
        writer.write("\t};\r\n");
        writer.write("}\r\n");
        writer.close();
        System.out.println("Done writing to " + outputFileName);
    }

    private static List<String> readEnums(String inputFileName) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(inputFileName));
        boolean weAreInBusiness = false;
        ArrayList<String> result = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            if (line.contains(ENUM_START_TAG)) {
                weAreInBusiness = true;
                continue;
            }
            if (line.contains(ENUM_END_TAG)) break;
            if (!weAreInBusiness || !(line = line.trim().replaceAll("\\s", "")).endsWith(",")) continue;
            result.add(line.substring(0, line.length() - 1));
        }
        return result;
    }
}

