/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ReaderState;
import com.rusefi.ReaderStateImpl;
import com.rusefi.TsFileContent;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.ConfigurationConsumer;
import com.rusefi.output.TsOutput;
import com.rusefi.util.IoUtils;
import com.rusefi.util.LazyFile;
import com.rusefi.util.Output;
import com.rusefi.util.SystemOut;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class TSProjectConsumer
implements ConfigurationConsumer {
    private static final String TS_FILE_INPUT_NAME = "rusefi.input";
    private static final String CONFIG_DEFINITION_START = "CONFIG_DEFINITION_START";
    private static final String CONFIG_DEFINITION_END = "CONFIG_DEFINITION_END";
    private static final String TS_CONDITION = "@@if_";
    public static final String SETTING_CONTEXT_HELP_END = "SettingContextHelpEnd";
    public static final String SETTING_CONTEXT_HELP = "SettingContextHelp";
    private final String tsPath;
    private final ReaderStateImpl state;
    private int totalTsSize;
    private final TsOutput tsOutput;

    public TSProjectConsumer(String tsPath, ReaderStateImpl state) {
        this.tsPath = tsPath;
        this.tsOutput = new TsOutput(true);
        this.state = state;
    }

    public String getSettingContextHelpForUnitTest() {
        return this.tsOutput.getSettingContextHelp();
    }

    protected void writeTunerStudioFile(String tsPath, String fieldsSection) throws IOException {
        TsFileContent tsContent = this.readTsTemplateInputFile(tsPath);
        SystemOut.println("Got " + tsContent.getPrefix().length() + "/" + tsContent.getPostfix().length() + " of " + TS_FILE_INPUT_NAME);
        String fileName = this.getTsFileOutputName(new File(tsPath).getPath());
        LazyFile tsHeader = new LazyFile(fileName);
        this.writeContent(fieldsSection, tsContent, tsHeader);
    }

    protected void writeContent(String fieldsSection, TsFileContent tsContent, Output tsHeader) throws IOException {
        tsHeader.write(tsContent.getPrefix());
        tsHeader.write("; CONFIG_DEFINITION_START\n");
        tsHeader.write("; this section " + this.state.getHeader() + "\n" + "\n");
        tsHeader.write("pageSize            = " + this.totalTsSize + "\n");
        tsHeader.write("page = 1\n");
        tsHeader.write(fieldsSection);
        if (this.tsOutput.getSettingContextHelp().length() > 0) {
            tsHeader.write("[SettingContextHelp]\n");
            tsHeader.write(this.tsOutput.getSettingContextHelp() + "\n" + "\n");
            tsHeader.write("; SettingContextHelpEnd\n");
        }
        tsHeader.write("; CONFIG_DEFINITION_END\n");
        tsHeader.write(tsContent.getPostfix());
        tsHeader.close();
    }

    private TsFileContent readTsTemplateInputFile(String tsPath) throws IOException {
        String line;
        String fileName = TSProjectConsumer.getTsFileInputName(tsPath);
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), IoUtils.CHARSET.name()));
        StringBuilder prefix = new StringBuilder();
        StringBuilder postfix = new StringBuilder();
        boolean isBeforeStartTag = true;
        boolean isAfterEndTag = false;
        while ((line = r.readLine()) != null) {
            if (line.contains(CONFIG_DEFINITION_START)) {
                isBeforeStartTag = false;
                continue;
            }
            if (line.contains(CONFIG_DEFINITION_END)) {
                isAfterEndTag = true;
                continue;
            }
            if (line.contains(TS_CONDITION)) {
                String token = TSProjectConsumer.getToken(line);
                String strValue = this.state.getVariableRegistry().get(token);
                boolean value = Boolean.parseBoolean(strValue);
                if (!value) continue;
                line = TSProjectConsumer.removeToken(line);
            }
            line = this.state.getVariableRegistry().applyVariables(line);
            if (isBeforeStartTag) {
                prefix.append(line + "\n");
            }
            if (!isAfterEndTag) continue;
            postfix.append(this.state.getVariableRegistry().applyVariables(line) + "\n");
        }
        r.close();
        return new TsFileContent(prefix.toString(), postfix.toString());
    }

    public static String removeToken(String line) {
        int index = line.indexOf(TS_CONDITION);
        String token = TSProjectConsumer.getToken(line);
        int afterTokenIndex = index + TS_CONDITION.length() + token.length();
        if (afterTokenIndex < line.length()) {
            ++afterTokenIndex;
        }
        line = line.substring(0, index) + line.substring(afterTokenIndex);
        return line;
    }

    public static String getToken(String line) {
        String token = "";
        for (int index = line.indexOf(TS_CONDITION) + TS_CONDITION.length(); index < line.length() && !Character.isWhitespace(line.charAt(index)); ++index) {
            token = token + line.charAt(index);
        }
        return token;
    }

    private String getTsFileOutputName(String tsPath) {
        return tsPath + File.separator + this.state.getTsFileOutputName();
    }

    public static String getTsFileInputName(String tsPath) {
        return tsPath + File.separator + TS_FILE_INPUT_NAME;
    }

    @Override
    public void endFile() throws IOException {
        this.writeTunerStudioFile(this.tsPath, this.getContent());
    }

    @Override
    public void handleEndStruct(ReaderState readerState, ConfigStructure structure) throws IOException {
        this.state.getVariableRegistry().register(structure.getName() + "_size", structure.getTotalSize());
        this.totalTsSize = this.tsOutput.run(readerState, structure, 0);
        if (this.state.isStackEmpty()) {
            this.state.getVariableRegistry().register("TOTAL_CONFIG_SIZE", this.totalTsSize);
        }
    }

    public String getContent() {
        return this.tsOutput.getContent();
    }
}

