/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.native_;

import com.opensr5.ConfigurationImage;
import com.rusefi.config.Field;
import com.rusefi.config.generated.Fields;
import com.rusefi.core.FileUtil;
import com.rusefi.core.Sensor;
import com.rusefi.enums.SensorType;
import com.rusefi.native_.EngineLogic;
import com.rusefi.native_.JniSandbox;
import java.nio.ByteBuffer;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class JniUnitTest {
    @Before
    public void reset() {
        JniSandbox.loadLibrary();
        EngineLogic.resetTest();
    }

    @Test
    public void run() {
        String version = EngineLogic.getVersion();
        Assert.assertTrue("Got " + version, version.contains("Hello"));
        EngineLogic engineLogic = new EngineLogic();
        engineLogic.invokePeriodicCallback();
        Assert.assertEquals(20210312, (int)this.getValue(engineLogic.getOutputs(), Sensor.FIRMWARE_VERSION));
        Assert.assertEquals(14.0, this.getValue(engineLogic.getOutputs(), Sensor.afrTarget));
        double veValue = this.getValue(engineLogic.getOutputs(), Sensor.veValue);
        Assert.assertTrue("veValue", veValue > 40.0 && veValue < 90.0);
        Assert.assertEquals(18.11, this.getValue(engineLogic.getOutputs(), Sensor.runningFuel));
        engineLogic.setSensor(SensorType.Rpm.name(), 4000.0);
        engineLogic.invokePeriodicCallback();
        Assert.assertEquals(4000.0, this.getValue(engineLogic.getOutputs(), Sensor.RPMValue));
        Assert.assertEquals(18.11, this.getValue(engineLogic.getOutputs(), Sensor.runningFuel));
        Assert.assertEquals(0.25096, this.getValue(engineLogic.getOutputs(), Sensor.sdAirMassInOneCylinder), 1.0E-4);
        engineLogic.setEngineType(11);
        Assert.assertEquals(2.45, this.getField(engineLogic, Fields.GEARRATIO1));
    }

    @Test
    public void testEtbStuff() {
        EngineLogic engineLogic = new EngineLogic();
        engineLogic.setSensor(SensorType.Tps1Primary.name(), 30.0);
        engineLogic.setSensor(SensorType.Tps1Secondary.name(), 30.0);
        engineLogic.burnRequest();
        engineLogic.setSensor(SensorType.AcceleratorPedalPrimary.name(), 40.0);
        engineLogic.setSensor(SensorType.AcceleratorPedalSecondary.name(), 40.0);
        engineLogic.setConfiguration(new byte[]{3}, Fields.TPS1_1ADCCHANNEL.getTotalOffset(), 1);
        engineLogic.setConfiguration(new byte[]{3}, Fields.TPS1_2ADCCHANNEL.getTotalOffset(), 1);
        engineLogic.setConfiguration(new byte[]{3}, Fields.THROTTLEPEDALPOSITIONADCCHANNEL.getTotalOffset(), 1);
        engineLogic.setConfiguration(new byte[]{3}, Fields.THROTTLEPEDALPOSITIONSECONDADCCHANNEL.getTotalOffset(), 1);
        engineLogic.initTps();
        engineLogic.burnRequest();
        System.out.println("engineLogic.invokeEtbCycle");
        engineLogic.invokeEtbCycle();
        Assert.assertEquals(120.36, this.getValue(engineLogic.getOutputs(), Sensor.etb1DutyCycle));
    }

    private double getField(EngineLogic engineLogic, Field field) {
        byte[] configuration = engineLogic.getConfiguration();
        Assert.assertNotNull("configuration", configuration);
        return field.getValue(new ConfigurationImage(configuration), field.getScale());
    }

    private double getValue(byte[] outputs, Sensor sensor) {
        ByteBuffer bb = FileUtil.littleEndianWrap(outputs, sensor.getOffset(), 4);
        return sensor.getValueForChannel(bb) * sensor.getScale();
    }
}

