/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.rusefi.Launcher;
import com.rusefi.SerialPortScanner;
import com.rusefi.StartupFrame;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.maintenance.DfuFlasher;
import com.rusefi.maintenance.ExecHelper;
import com.rusefi.maintenance.FirmwareFlasher;
import com.rusefi.ui.StatusWindow;
import com.rusefi.ui.util.URLLabel;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ProgramSelector {
    private static final String AUTO_DFU = "Auto Update";
    private static final String MANUAL_DFU = "Manual DFU Update";
    private static final String DFU_SWITCH = "Switch to DFU Mode";
    private static final String DFU_ERASE = "Full Chip Erase";
    private static final String ST_LINK = "ST-LINK Update";
    private static final String OPENBLT_CAN = "OpenBLT via CAN";
    public static final boolean IS_WIN = System.getProperty("os.name").toLowerCase().contains("win");
    private static final String HELP = "https://github.com/rusefi/rusefi/wiki/HOWTO-Update-Firmware";
    public static final String BOOT_COMMANDER_EXE = "BootCommander.exe";
    public static final String OPENBLT_BINARY_LOCATION = Launcher.TOOLS_PATH + File.separator + "openblt";
    private final JPanel content = new JPanel(new BorderLayout());
    private final JLabel noHardware = new JLabel("Nothing detected");
    private final JPanel controls = new JPanel(new FlowLayout());
    private final JComboBox<String> mode = new JComboBox();

    public ProgramSelector(final JComboBox<String> comboPorts) {
        this.content.add((Component)this.controls, "North");
        this.content.add((Component)this.noHardware, "South");
        this.controls.setVisible(false);
        this.controls.add(this.mode);
        String persistedMode = PersistentConfiguration.getConfig().getRoot().getProperty(this.getClass().getSimpleName());
        if (Arrays.asList(AUTO_DFU, MANUAL_DFU, ST_LINK, OPENBLT_CAN, DFU_ERASE, DFU_SWITCH).contains(persistedMode)) {
            this.mode.setSelectedItem(persistedMode);
        }
        final JButton updateFirmware = new JButton("Update Firmware", AutoupdateUtil.loadIcon("upload48.png"));
        this.controls.add(updateFirmware);
        updateFirmware.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedMode = (String)ProgramSelector.this.mode.getSelectedItem();
                PersistentConfiguration.getConfig().getRoot().setProperty(this.getClass().getSimpleName(), selectedMode);
                Objects.requireNonNull(selectedMode);
                switch (selectedMode) {
                    case "Auto Update": {
                        DfuFlasher.doAutoDfu(comboPorts.getSelectedItem(), comboPorts);
                        break;
                    }
                    case "Manual DFU Update": {
                        DfuFlasher.runDfuProgramming();
                        break;
                    }
                    case "ST-LINK Update": {
                        FirmwareFlasher.doUpdateFirmware(FirmwareFlasher.IMAGE_FILE, updateFirmware);
                        break;
                    }
                    case "Switch to DFU Mode": {
                        StatusWindow wnd = DfuFlasher.createStatusWindow();
                        Object selected = comboPorts.getSelectedItem();
                        String port = selected == null ? "auto" : selected.toString();
                        DfuFlasher.rebootToDfu(comboPorts, port, wnd);
                        break;
                    }
                    case "OpenBLT via CAN": {
                        ProgramSelector.this.flashOpenBltCan();
                        break;
                    }
                    case "Full Chip Erase": {
                        DfuFlasher.runDfuErase();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("How did you " + selectedMode);
                    }
                }
            }
        });
    }

    private void flashOpenBltCan() {
        StatusWindow wnd = new StatusWindow();
        wnd.showFrame(StartupFrame.appendBundleName("OpenBLT via CAN 20230107"));
        ExecHelper.submitAction(() -> {
            ExecHelper.executeCommand(OPENBLT_BINARY_LOCATION, OPENBLT_BINARY_LOCATION + "/" + BOOT_COMMANDER_EXE + " -s=xcp -t=xcp_can -d=peak_pcanusb -t1=1000 -t3=2000 -t4=10000 -t5=1000 -t7=2000 ../../rusefi_update.srec", BOOT_COMMANDER_EXE, wnd, new StringBuffer());
            Toolkit.getDefaultToolkit().beep();
        }, OPENBLT_CAN);
    }

    @NotNull
    public static JComponent createHelpButton() {
        return new URLLabel("HOWTO Update Firmware", HELP);
    }

    public JPanel getControl() {
        return this.content;
    }

    public void apply(SerialPortScanner.AvailableHardware currentHardware) {
        this.noHardware.setVisible(currentHardware.isEmpty());
        this.controls.setVisible(!currentHardware.isEmpty());
        this.mode.removeAllItems();
        if (IS_WIN) {
            if (!currentHardware.getKnownPorts().isEmpty()) {
                this.mode.addItem(AUTO_DFU);
            }
            if (currentHardware.isDfuFound()) {
                this.mode.addItem(MANUAL_DFU);
                this.mode.addItem(DFU_ERASE);
            }
            if (currentHardware.isStLinkConnected()) {
                this.mode.addItem(ST_LINK);
            }
            if (currentHardware.isPCANConnected()) {
                this.mode.addItem(OPENBLT_CAN);
            }
        }
        if (!currentHardware.getKnownPorts().isEmpty()) {
            this.mode.addItem(DFU_SWITCH);
        }
        UiUtils.trueLayout(this.mode);
        UiUtils.trueLayout(this.content);
    }
}

