/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini;

import com.devexperts.logging.Logging;
import com.opensr5.ini.DialogModel;
import com.opensr5.ini.IniFileReader;
import com.opensr5.ini.RawIniFile;
import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.EnumIniField;
import com.opensr5.ini.field.IniField;
import com.opensr5.ini.field.ScalarIniField;
import com.opensr5.ini.field.StringIniField;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;

public class IniFileModel {
    private static final Logging log = Logging.getLogging(IniFileModel.class);
    public static final String RUSEFI_INI_PREFIX = "rusefi";
    public static final String RUSEFI_INI_SUFFIX = ".ini";
    public static final String INI_FILE_PATH = System.getProperty("ini_file_path", "..");
    private static final String SECTION_PAGE = "page";
    private static final String FIELD_TYPE_SCALAR = "scalar";
    public static final String FIELD_TYPE_STRING = "string";
    private static final String FIELD_TYPE_ARRAY = "array";
    private static final String FIELD_TYPE_BITS = "bits";
    private static IniFileModel INSTANCE;
    private String dialogId;
    private String dialogUiName;
    private Map<String, DialogModel> dialogs = new TreeMap<String, DialogModel>();
    private Map<String, DialogModel.Field> allFields = new TreeMap<String, DialogModel.Field>(String.CASE_INSENSITIVE_ORDER);
    private List<DialogModel.Field> fieldsOfCurrentDialog = new ArrayList<DialogModel.Field>();
    public Map<String, IniField> allIniFields = new TreeMap<String, IniField>(String.CASE_INSENSITIVE_ORDER);
    public Map<String, String> tooltips = new TreeMap<String, String>();
    public Map<String, String> protocolMeta = new TreeMap<String, String>();
    private boolean isConstantsSection;
    private String currentSection;
    private boolean isInSettingContextHelp = false;
    private boolean isInsidePageDefinition;

    public static void main(String[] args) {
        log.info("Dialogs: " + IniFileModel.getInstance().dialogs);
    }

    public IniFileModel findAndReadIniFile(String iniFilePath) {
        String fileName = IniFileModel.findMetaInfoFile(iniFilePath);
        return this.readIniFile(fileName);
    }

    public IniFileModel readIniFile(String fileName) {
        File input = null;
        if (fileName != null) {
            input = new File(fileName);
        }
        if (fileName == null || !input.exists()) {
            log.error("No such file: " + fileName);
            return null;
        }
        log.info("Reading " + fileName);
        RawIniFile content = IniFileReader.read(input);
        this.readIniFile(content);
        return this;
    }

    public IniFileModel readIniFile(RawIniFile content) {
        for (RawIniFile.Line line : content.getLines()) {
            this.handleLine(line);
        }
        this.finishDialog();
        return this;
    }

    private static String findMetaInfoFile(String iniFilePath) {
        return IniFileModel.findFile(iniFilePath, RUSEFI_INI_PREFIX, RUSEFI_INI_SUFFIX);
    }

    @Nullable
    public static String findFile(String fileDirectory, String prefix, String suffix) {
        File dir = new File(fileDirectory);
        if (!dir.isDirectory()) {
            return null;
        }
        log.info("Searching for " + prefix + "*" + suffix + " in " + fileDirectory);
        for (String file : dir.list()) {
            if (file.contains(" ") || !file.startsWith(prefix) || !file.endsWith(suffix)) continue;
            return fileDirectory + File.separator + file;
        }
        return null;
    }

    private void finishDialog() {
        if (this.fieldsOfCurrentDialog.isEmpty()) {
            return;
        }
        if (this.dialogUiName == null) {
            this.dialogUiName = this.dialogId;
        }
        this.dialogs.put(this.dialogUiName, new DialogModel(this.dialogId, this.dialogUiName, this.fieldsOfCurrentDialog));
        this.dialogId = null;
        this.fieldsOfCurrentDialog.clear();
    }

    private void handleLine(RawIniFile.Line line) {
        String rawText = line.getRawText();
        try {
            LinkedList<String> list = new LinkedList<String>(Arrays.asList(line.getTokens()));
            if (!list.isEmpty() && list.get(0).equals(SECTION_PAGE)) {
                this.isInsidePageDefinition = true;
                return;
            }
            if (this.isInSettingContextHelp) {
                if (rawText.contains("SettingContextHelpEnd")) {
                    this.isInSettingContextHelp = false;
                }
                if (list.size() == 2) {
                    this.tooltips.put(list.get(0), list.get(1));
                }
                return;
            }
            if (rawText.contains("SettingContextHelp")) {
                this.isInsidePageDefinition = false;
                this.isInSettingContextHelp = true;
                return;
            }
            if (RawIniFile.Line.isCommentLine(rawText)) {
                return;
            }
            if (RawIniFile.Line.isPreprocessorDirective(rawText)) {
                return;
            }
            this.trim(list);
            if (list.isEmpty()) {
                return;
            }
            String first = list.getFirst();
            if (first.startsWith("[") && first.endsWith("]")) {
                log.info("Section " + first);
                this.currentSection = first;
                this.isConstantsSection = first.equals("[Constants]");
            }
            if (this.isConstantsSection) {
                if (this.isInsidePageDefinition) {
                    if (list.size() > 1) {
                        this.handleFieldDefinition(list);
                    }
                    return;
                }
                if (list.size() > 1) {
                    this.protocolMeta.put(list.get(0), list.get(1));
                }
            }
            if ("dialog".equals(first)) {
                this.handleDialog(list);
            } else if ("field".equals(first)) {
                this.handleField(list);
            }
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("While [" + rawText + "]", e);
        }
    }

    private void handleFieldDefinition(LinkedList<String> list) {
        if (list.get(1).equals(FIELD_TYPE_SCALAR)) {
            this.registerField(ScalarIniField.parse(list));
        } else if (list.get(1).equals(FIELD_TYPE_STRING)) {
            this.registerField(StringIniField.parse(list));
        } else if (list.get(1).equals(FIELD_TYPE_ARRAY)) {
            this.registerField(ArrayIniField.parse(list));
        } else if (list.get(1).equals(FIELD_TYPE_BITS)) {
            this.registerField(EnumIniField.parse(list));
        } else {
            throw new IllegalStateException("Unexpected " + list);
        }
    }

    private void registerField(IniField field) {
        this.allIniFields.put(field.getName(), field);
    }

    private void handleField(LinkedList<String> list) {
        list.removeFirst();
        String uiFieldName = list.isEmpty() ? "" : list.removeFirst();
        String key = list.isEmpty() ? null : list.removeFirst();
        DialogModel.Field field = new DialogModel.Field(key, uiFieldName);
        if (key != null) {
            this.allFields.put(key, field);
        }
        this.fieldsOfCurrentDialog.add(field);
        log.debug("IniFileModel: Field label=[" + uiFieldName + "] : key=[" + key + "]");
    }

    public Map<String, DialogModel.Field> getAllFields() {
        return this.allFields;
    }

    @Nullable
    public DialogModel.Field getField(String key) {
        return this.allFields.get(key);
    }

    private void handleDialog(LinkedList<String> list) {
        this.finishDialog();
        list.removeFirst();
        String keyword = list.removeFirst();
        String name = list.isEmpty() ? null : list.removeFirst();
        this.dialogId = keyword;
        this.dialogUiName = name;
        log.debug("IniFileModel: Dialog key=" + keyword + ": name=[" + name + "]");
    }

    private void trim(LinkedList<String> list) {
        while (!list.isEmpty() && list.getFirst().isEmpty()) {
            list.removeFirst();
        }
    }

    public IniField findByOffset(int i) {
        for (IniField field : this.allIniFields.values()) {
            if (i < field.getOffset() || i >= field.getOffset() + field.getSize()) continue;
            return field;
        }
        return null;
    }

    public static synchronized IniFileModel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new IniFileModel();
            INSTANCE.findAndReadIniFile(INI_FILE_PATH);
        }
        return INSTANCE;
    }

    public Map<String, DialogModel> getDialogs() {
        return this.dialogs;
    }
}

