/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.livedata;

import com.rusefi.CodeWalkthrough;
import com.rusefi.enums.live_data_e;
import com.rusefi.ldmp.StateDictionary;
import com.rusefi.livedata.LiveDataParserPanel;
import com.rusefi.livedata.LiveDataParserSandbox;
import com.rusefi.livedata.ParseResult;
import com.rusefi.ui.livedata.PrintCPP14ParserListener;
import com.rusefi.ui.livedata.Range;
import com.rusefi.ui.livedata.SourceCodePainter;
import com.rusefi.ui.livedata.VariableValueSource;
import java.awt.Color;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.TreeMap;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class LiveDataParserTest {
    @Test
    public void testGreenCode() {
        String sourceCode = "void AcController::onSlowCallback() {\n\tbool isEnabled = getAcState();\n\n\tm_acEnabled = isEnabled;\nauto [cltValid, clt] = Sensor::get(SensorType::Clt);\n\n\tenginePins.acRelay.setValue(isEnabled);\n\n#if EFI_TUNER_STUDIO\n\tengine->outputChannels.acState = isEnabled;\n#endif // EFI_TUNER_STUDIO\n}\n";
        SourceCodePainter painter = this.run(name -> null, sourceCode);
        ((SourceCodePainter)Mockito.verify((Object)painter, (VerificationMode)Mockito.times((int)7))).paintBackground((Color)Matchers.eq((Object)CodeWalkthrough.ACTIVE_STATEMENT), (Range)Matchers.any());
    }

    @Test
    public void testMethodNamesCode() {
        String sourceCode = "void AcController::onSlowCallback() {\n}\nvoid onSlowCallback2() {\n                }\nint onSlowCallback3() {\n                }\n";
        SourceCodePainter painter = (SourceCodePainter)Mockito.mock(SourceCodePainter.class);
        ParseTree tree = LiveDataParserPanel.getParseTree(sourceCode);
        LiveDataParserTest.printTree(tree);
        ParseResult result = CodeWalkthrough.applyVariables(name -> null, sourceCode, painter, tree);
        Assert.assertEquals(3L, result.getFunctions().size());
    }

    @Test
    public void testParsing() {
        TreeMap<String, Double> values = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
        values.put("engineTooSlow", 1.0);
        values.put("engineTooFast", 1.0);
        VariableValueSource valueSource = LiveDataParserSandbox.getVariableValueSource(values);
        String sourceCode = "bool AcState::getAcState() {\n\tauto rpm = Sensor::getOrZero(SensorType::Rpm);\n\n\tif (engineTooSlow) {\n\t\tinvokeMethod();\n\t\treturn true;\n\t} else {\n  auto ff2 = engineConfiguration->Alternatorcontrolpin;\n\t}\n  auto ff = engineConfiguration->tpsMax;\n\tif (engineTooFast) {\n\t\treturn false;\n\t} \n  return ff;\n}\nbool AcState::getAcState2() {\nreturn ff;\n}\n";
        SourceCodePainter painter = this.run(valueSource, sourceCode);
        ((SourceCodePainter)Mockito.verify((Object)painter, (VerificationMode)Mockito.times((int)2))).paintForeground((Color)Matchers.eq((Object)CodeWalkthrough.CONFIG), (Range)Matchers.any());
        ((SourceCodePainter)Mockito.verify((Object)painter)).paintBackground((Color)Matchers.eq((Object)CodeWalkthrough.TRUE_CONDITION), (Range)Matchers.any());
        ((SourceCodePainter)Mockito.verify((Object)painter, (VerificationMode)Mockito.times((int)4))).paintBackground((Color)Matchers.eq((Object)CodeWalkthrough.ACTIVE_STATEMENT), (Range)Matchers.any());
        ((SourceCodePainter)Mockito.verify((Object)painter, (VerificationMode)Mockito.times((int)5))).paintBackground((Color)Matchers.eq((Object)CodeWalkthrough.PASSIVE_CODE), (Range)Matchers.any());
    }

    private SourceCodePainter run(VariableValueSource valueSource, String sourceCode) {
        SourceCodePainter painter = (SourceCodePainter)Mockito.mock(SourceCodePainter.class);
        ParseTree tree = LiveDataParserPanel.getParseTree(sourceCode);
        LiveDataParserTest.printTree(tree);
        CodeWalkthrough.applyVariables(valueSource, sourceCode, painter, tree);
        return painter;
    }

    private static void printTree(ParseTree tree) {
        System.out.println("******************************************* Just print everything for educational purposes");
        new ParseTreeWalker().walk(new PrintCPP14ParserListener(), tree);
        System.out.println("******************************************* Now running FOR REAL");
    }

    @Test
    public void testConfigurationInRealSourceCode() throws IOException, URISyntaxException {
        String fileName = StateDictionary.INSTANCE.getFileName(live_data_e.LDS_boost_control);
        String sourceCode = LiveDataParserPanel.getContent(LiveDataParserPanel.class, fileName + ".cpp");
        Assert.assertTrue(sourceCode.length() > 100);
        ParseTree tree = LiveDataParserPanel.getParseTree(sourceCode);
        LiveDataParserTest.printTree(tree);
        ParseResult parseResult = CodeWalkthrough.applyVariables(VariableValueSource.VOID, sourceCode, SourceCodePainter.VOID, tree);
        Assert.assertFalse(parseResult.getConfigTokens().isEmpty());
    }
}

