/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.core.preferences.storage.Node;
import com.rusefi.ui.MessagesView;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MessagesPanel {
    private static final String FONT_SIZE = "font_size";
    private static final String FONT_NAME = "font_name";
    private final MessagesView messagesView;
    private final JPanel buttonPanel = new JPanel(new FlowLayout(1, 5, 0));
    private final JButton pauseButton = UiUtils.createPauseButton();

    public MessagesPanel(JComponent extraButton, Node config) {
        JPanel middlePanel = new JPanel(new BorderLayout());
        this.messagesView = new MessagesView(config);
        middlePanel.add((Component)this.messagesView.messagesScroll, "Center");
        this.pauseButton.addActionListener(event -> this.setPaused(!this.messagesView.isPaused()));
        JButton clearButton = UiUtils.createClearButton();
        clearButton.addActionListener(event -> {
            this.messagesView.clear();
            this.setPaused(false);
        });
        this.buttonPanel.add(clearButton);
        this.buttonPanel.add(this.pauseButton);
        if (extraButton != null) {
            this.buttonPanel.add(extraButton);
        }
    }

    public void setPaused(boolean isPaused) {
        this.messagesView.setPaused(isPaused);
        UiUtils.setPauseButtonText(this.pauseButton, this.messagesView.isPaused());
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public JScrollPane getMessagesScroll() {
        return this.messagesView.messagesScroll;
    }

    public Font getFont() {
        return this.messagesView.messages.getFont();
    }

    public void setFont(Font font, Node config) {
        this.messagesView.messages.setFont(font);
        config.setProperty(FONT_SIZE, font.getSize());
        config.setProperty(FONT_NAME, font.getName());
    }

    public void loadFont(Node config) {
        Font f = this.getFont();
        int size = config.getIntProperty(FONT_SIZE, f.getSize());
        String name = config.getProperty(FONT_NAME, f.getName());
        this.setFont(new Font(name, f.getStyle(), size), config);
    }
}

