/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.stream;

import com.rusefi.composite.CompositeEvent;
import com.rusefi.stream.LogicdataStreamFile;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LogicdataStreamFileCsvSandbox {
    private static final int maxDelayTime = 1000000;

    public static void main(String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("I want file name parameter please");
        }
        String filename = args[0];
        List<CompositeEvent> events = LogicdataStreamFileCsvSandbox.readCsvFile(filename);
        LogicdataStreamFile file = new LogicdataStreamFile(args[1]);
        file.append(events);
        file.close();
    }

    @NotNull
    private static List<CompositeEvent> readCsvFile(String filename) {
        ArrayList<CompositeEvent> events = new ArrayList<CompositeEvent>();
        try {
            String line;
            System.out.println("Reading " + filename);
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            reader.readLine();
            reader.readLine();
            reader.readLine();
            int cur_time = 0;
            while ((line = reader.readLine()) != null) {
                String[] tokens = line.split(",");
                int v1 = Integer.parseInt(tokens[0]);
                int v2 = Integer.parseInt(tokens[1]);
                int v3 = Integer.parseInt(tokens[2]);
                int v4 = Integer.parseInt(tokens[3]);
                int time = (int)(Double.parseDouble(tokens[4]) * 1000.0);
                int dt = (int)(Double.parseDouble(tokens[5]) * 1000.0);
                int v5 = Integer.parseInt(tokens[6]);
                int v6 = Integer.parseInt(tokens[7]);
                if (dt < 0 || dt > 1000000) {
                    dt = 1000000;
                }
                cur_time = Math.addExact(cur_time, dt);
                System.out.println("* " + cur_time);
                events.add(new CompositeEvent(cur_time, v1 == 1, v2 == 1, v3 == 1, v4 == 1, v5 == 1, v6 == 1));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        System.out.println("Found " + events.size() + " records");
        return events;
    }
}

