/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.dfu.usb4java;

import com.rusefi.dfu.DfuCommmand;
import com.rusefi.dfu.DfuConnection;
import com.rusefi.dfu.FlashRange;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;

public class USBDfuConnection
implements DfuConnection {
    private final DeviceHandle deviceHandle;
    private final byte interfaceNumber;
    private final int transferSize;
    private final FlashRange flashRange;

    public USBDfuConnection(DeviceHandle deviceHandle, byte interfaceNumber, int transferSize, FlashRange flashRange) {
        if (transferSize == 0) {
            throw new IllegalArgumentException("transfer size not detected");
        }
        Objects.requireNonNull(flashRange, "flashRange");
        this.deviceHandle = deviceHandle;
        this.interfaceNumber = interfaceNumber;
        this.transferSize = transferSize;
        this.flashRange = flashRange;
    }

    @Override
    public FlashRange getFlashRange() {
        return this.flashRange;
    }

    @Override
    public int getTransferSize() {
        return this.transferSize;
    }

    @Override
    public int receiveData(DfuCommmand command, short wValue, ByteBuffer data) {
        return this.transfer(command, wValue, data, (byte)-128);
    }

    @Override
    public int sendData(DfuCommmand command, short wValue, ByteBuffer data) {
        return this.transfer(command, wValue, data, (byte)0);
    }

    @Override
    public ByteBuffer allocateBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity);
    }

    private int transfer(DfuCommmand command, short wValue, ByteBuffer data, byte mode) {
        return LibUsb.controlTransfer(this.deviceHandle, (byte)(mode | 0x20 | 1), command.getValue(), wValue, this.interfaceNumber, data, 10000L);
    }
}

