/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.dfu.usb4java;

import com.rusefi.dfu.DfuLogic;
import com.rusefi.dfu.DfuSeFlashDescriptor;
import com.rusefi.dfu.FlashRange;
import com.rusefi.dfu.LogUtil;
import com.rusefi.dfu.usb4java.USBDfuConnection;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.usb4java.ConfigDescriptor;
import org.usb4java.Context;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.DeviceList;
import org.usb4java.Interface;
import org.usb4java.InterfaceDescriptor;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public class DfuDeviceLocator {
    private static final Log log = LogUtil.getLog(DfuDeviceLocator.class);
    private static StringBuilder usbInfo = new StringBuilder();

    public static Context openContext() {
        Context context = new Context();
        int result = LibUsb.init(context);
        if (result != 0) {
            throw new LibUsbException("init", result);
        }
        log.info("Welcome " + context);
        return context;
    }

    public static USBDfuConnection findDevice(DfuLogic.Logger logger) {
        return DfuDeviceLocator.findDevice(logger, DfuDeviceLocator.openContext(), (short)1155, (short)-8431);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static USBDfuConnection findDevice(DfuLogic.Logger logger, Context context, short vendorId, short productId) {
        DeviceList list = new DeviceList();
        int result = LibUsb.getDeviceList(context, list);
        if (result < 0) {
            throw new LibUsbException("getDeviceList", result);
        }
        log.info(list.getSize() + " device(s) found");
        try {
            for (Device device : list) {
                DeviceDescriptor descriptor;
                result = LibUsb.getDeviceDescriptor(device, descriptor = new DeviceDescriptor());
                if (result != 0) {
                    throw new LibUsbException("getDeviceDescriptor", result);
                }
                if (descriptor.idVendor() != vendorId || descriptor.idProduct() != productId) continue;
                USBDfuConnection uSBDfuConnection = DfuDeviceLocator.findDfuInterface(logger, device, descriptor);
                return uSBDfuConnection;
            }
        }
        finally {
            LibUsb.freeDeviceList(list, true);
        }
        return null;
    }

    public static int swap16(int x) {
        return (x & 0xFF) << 8 | x >> 8 & 0xFF;
    }

    public static USBDfuConnection findDfuInterface(DfuLogic.Logger logger, Device device, DeviceDescriptor deviceDescriptor) {
        int numConfigurations = deviceDescriptor.bNumConfigurations();
        DfuDeviceLocator.appendInfo(numConfigurations + " configuration(s)");
        DeviceHandle deviceHandle = DfuDeviceLocator.open(device);
        int transferSize = 0;
        for (int configurationIndex = 0; configurationIndex < numConfigurations; ++configurationIndex) {
            ConfigDescriptor config = new ConfigDescriptor();
            int result = LibUsb.getConfigDescriptor(device, (byte)configurationIndex, config);
            if (result != 0) {
                throw new LibUsbException("getConfigDescriptor", result);
            }
            DfuDeviceLocator.appendInfo("Config: " + config);
            int numInterfaces = config.bNumInterfaces();
            DfuDeviceLocator.appendInfo(numInterfaces + " interface(s)");
            transferSize = DfuDeviceLocator.scanTransferSize(config, (byte)numInterfaces);
            DfuDeviceLocator.scanDescriptor(deviceHandle, config, (byte)numInterfaces);
            for (int interfaceIndex = 0; interfaceIndex < numInterfaces; ++interfaceIndex) {
                Interface iface = config.iface()[interfaceIndex];
                for (int s = 0; s < iface.numAltsetting(); ++s) {
                    InterfaceDescriptor setting = iface.altsetting()[s];
                    byte interfaceNumber = setting.bInterfaceNumber();
                    log.info("Settings " + setting + " " + interfaceNumber);
                    if (setting.bInterfaceClass() != -2 || setting.bInterfaceSubClass() != 1) continue;
                    log.debug(String.format("Found DFU interface: %d", interfaceNumber));
                    String stringDescriptor = LibUsb.getStringDescriptor(deviceHandle, setting.iInterface());
                    log.info("StringDescriptor: " + stringDescriptor);
                    if (!stringDescriptor.contains("Flash")) continue;
                    FlashRange flashRange = DfuSeFlashDescriptor.parse(stringDescriptor);
                    result = LibUsb.claimInterface(deviceHandle, interfaceNumber);
                    if (result != 0) {
                        throw new LibUsbException("claimInterface", result);
                    }
                    USBDfuConnection session = new USBDfuConnection(deviceHandle, interfaceNumber, transferSize, flashRange);
                    System.out.printf("info:\n" + usbInfo, new Object[0]);
                    return session;
                }
            }
        }
        return null;
    }

    private static void scanDescriptor(DeviceHandle deviceHandle, ConfigDescriptor config, byte numInterfaces) {
        for (int interfaceIndex = 0; interfaceIndex < numInterfaces; ++interfaceIndex) {
            Interface iface = config.iface()[interfaceIndex];
            for (int s = 0; s < iface.numAltsetting(); ++s) {
                InterfaceDescriptor setting = iface.altsetting()[s];
                DfuDeviceLocator.appendInfo("Interface #" + interfaceIndex + " setting #" + s + ":");
                byte interfaceNumber = setting.bInterfaceNumber();
                DfuDeviceLocator.appendInfo(String.format("Setting %d: %x %x class %x, subclass %x, protocol: %x", s, interfaceNumber, setting.iInterface(), setting.bInterfaceClass(), setting.bInterfaceSubClass(), setting.bInterfaceProtocol()));
                String stringDescriptor = LibUsb.getStringDescriptor(deviceHandle, setting.iInterface());
                DfuDeviceLocator.appendInfo("Descriptor " + stringDescriptor);
            }
        }
    }

    private static int scanTransferSize(ConfigDescriptor config, byte numInterfaces) {
        int transferSize = 0;
        for (int interfaceIndex = 0; interfaceIndex < numInterfaces; ++interfaceIndex) {
            Interface iface = config.iface()[interfaceIndex];
            for (int s = 0; s < iface.numAltsetting(); ++s) {
                InterfaceDescriptor setting = iface.altsetting()[s];
                System.out.println("setting " + setting);
                ByteBuffer extra = setting.extra();
                if (extra.limit() <= 2) continue;
                byte len = extra.get();
                byte type = extra.get();
                if (type != 33) continue;
                System.out.println(len + " " + type);
                extra.get();
                extra.get();
                extra.get();
                transferSize = DfuDeviceLocator.swap16(extra.getShort());
                System.out.println("transferSize " + transferSize);
            }
        }
        return transferSize;
    }

    private static void appendInfo(String message) {
        log.info(message);
        usbInfo.append(message).append("\n");
    }

    private static DeviceHandle open(Device device) {
        DeviceHandle deviceHandle = new DeviceHandle();
        int result = LibUsb.open(device, deviceHandle);
        if (result != 0) {
            throw new LibUsbException("open", result);
        }
        result = LibUsb.setConfiguration(deviceHandle, 1);
        if (result != 0) {
            throw new LibUsbException("setConfiguration", result);
        }
        return deviceHandle;
    }
}

