/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.rusefi.ui.StatusConsumer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ExecHelper {
    private static boolean isRunning(Process p) {
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    private static void startStreamThread(Process p, InputStream stream, StringBuffer buffer, StatusConsumer wnd) {
        Thread t = new Thread(() -> {
            try {
                String line;
                BufferedReader bis = new BufferedReader(new InputStreamReader(stream, StandardCharsets.ISO_8859_1));
                long wasRunningTime = System.currentTimeMillis();
                while ((ExecHelper.isRunning(p) || (double)(System.currentTimeMillis() - wasRunningTime) < 500.0) && (line = bis.readLine()) != null) {
                    wnd.append(line);
                    buffer.append(line);
                    wasRunningTime = System.currentTimeMillis();
                }
            }
            catch (IOException e) {
                wnd.append("Stream " + e);
            }
        });
        t.setDaemon(true);
        t.start();
    }

    @NotNull
    public static String executeCommand(String workingDirPath, String command, String binaryRelativeName, StatusConsumer wnd) {
        return ExecHelper.executeCommand(workingDirPath, command, binaryRelativeName, wnd, new StringBuffer());
    }

    @NotNull
    public static String executeCommand(String workingDirPath, String command, String binaryRelativeName, StatusConsumer wnd, StringBuffer output) {
        StringBuffer error = new StringBuffer();
        String binaryFullName = workingDirPath + File.separator + binaryRelativeName;
        if (!new File(binaryFullName).exists()) {
            wnd.append(binaryFullName + " not found :(");
            return error.toString();
        }
        File workingDir = new File(workingDirPath);
        return ExecHelper.executeCommand(command, wnd, output, error, workingDir);
    }

    @NotNull
    public static String executeCommand(String command, StatusConsumer wnd, StringBuffer output, StringBuffer error, File workingDir) {
        wnd.append("Executing " + command);
        try {
            Process p = Runtime.getRuntime().exec(command, null, workingDir);
            ExecHelper.startStreamThread(p, p.getInputStream(), output, wnd);
            ExecHelper.startStreamThread(p, p.getErrorStream(), error, wnd);
            p.waitFor(3L, TimeUnit.MINUTES);
        }
        catch (IOException e) {
            wnd.append("IOError: " + e);
        }
        catch (InterruptedException e) {
            wnd.append("WaitError: " + e);
        }
        wnd.append("Done!");
        return error.toString();
    }

    public static void submitAction(Runnable runnable, String threadName) {
        Thread thread = new Thread(runnable, threadName);
        thread.setDaemon(true);
        thread.start();
    }

    @NotNull
    public static String getBatchCommand(String batch) {
        return "cmd /c start " + batch;
    }
}

