/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ldmp;

import com.rusefi.config.Field;
import com.rusefi.config.generated.AcControl;
import com.rusefi.config.generated.AntilagSystem;
import com.rusefi.config.generated.BoostControl;
import com.rusefi.config.generated.ElectronicThrottle;
import com.rusefi.config.generated.EngineState;
import com.rusefi.config.generated.FuelComputer;
import com.rusefi.config.generated.FuelPump;
import com.rusefi.config.generated.HighPressureFuelPump;
import com.rusefi.config.generated.IdleState;
import com.rusefi.config.generated.IgnitionState;
import com.rusefi.config.generated.InjectorModel;
import com.rusefi.config.generated.KnockController;
import com.rusefi.config.generated.LaunchControl;
import com.rusefi.config.generated.MainRelay;
import com.rusefi.config.generated.TpsAccelState;
import com.rusefi.config.generated.TriggerCentral;
import com.rusefi.config.generated.TriggerState;
import com.rusefi.config.generated.TriggerStatePrimary;
import com.rusefi.config.generated.TsOutputs;
import com.rusefi.config.generated.WallFuelState;
import com.rusefi.config.generated.WidebandController;
import com.rusefi.enums.live_data_e;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum StateDictionary {
    INSTANCE;

    private final Map<live_data_e, Field[]> map = new HashMap<live_data_e, Field[]>();
    private final Map<live_data_e, String> fileNames = new HashMap<live_data_e, String>();

    private StateDictionary() {
        this.register(live_data_e.LDS_output_channels, TsOutputs.VALUES, "status_loop");
        this.register(live_data_e.LDS_engine_state, EngineState.VALUES, "engine");
        this.register(live_data_e.LDS_trigger_central, TriggerCentral.VALUES, "trigger_central");
        this.register(live_data_e.LDS_trigger_state, TriggerState.VALUES, "trigger_decoder");
        this.register(live_data_e.LDS_ac_control, AcControl.VALUES, "ac_control");
        this.register(live_data_e.LDS_fan_control, FuelPump.VALUES, "fan_control");
        this.register(live_data_e.LDS_injector_model, InjectorModel.VALUES, "injector_model");
        this.register(live_data_e.LDS_idle_state, IdleState.VALUES, "idle_thread");
        this.register(live_data_e.LDS_fuel_pump_control, FuelPump.VALUES, "fuel_pump");
        this.register(live_data_e.LDS_wall_fuel_state, WallFuelState.VALUES, "wall_fuel");
        this.register(live_data_e.LDS_tps_accel_state, TpsAccelState.VALUES, "accel_enrichment");
        this.register(live_data_e.LDS_main_relay, MainRelay.VALUES, "main_relay");
        this.register(live_data_e.LDS_boost_control, BoostControl.VALUES, "boost_control");
        this.register(live_data_e.LDS_launch_control_state, LaunchControl.VALUES, "launch_control");
        this.register(live_data_e.LDS_high_pressure_fuel_pump, HighPressureFuelPump.VALUES, "high_pressure_fuel_pump");
        this.register(live_data_e.LDS_ignition_state, IgnitionState.VALUES, "advance_map");
        this.register(live_data_e.LDS_electronic_throttle, ElectronicThrottle.VALUES, "electronic_throttle");
        this.register(live_data_e.LDS_knock_controller, KnockController.VALUES, "knock_controller");
        this.register(live_data_e.LDS_wideband_state, WidebandController.VALUES, "AemXSeriesLambda");
        this.register(live_data_e.LDS_trigger_state_primary, TriggerStatePrimary.VALUES, "trigger_decoder");
        this.register(live_data_e.LDS_fuel_computer, FuelComputer.VALUES, "fuel_computer");
        this.register(live_data_e.LDS_antilag_system_state, AntilagSystem.VALUES, "antilag_system");
        if (this.map.size() != live_data_e.values().length) {
            HashSet<live_data_e> missing = new HashSet<live_data_e>(Arrays.asList(live_data_e.values()));
            missing.removeAll(this.map.keySet());
            throw new IllegalStateException("Some live_data_e does not have values: " + missing);
        }
    }

    static int getSize(Field[] values) {
        Field last = values[values.length - 1];
        return last.getOffset() + last.getType().getStorageSize();
    }

    public int getOffset(live_data_e live_data_e2) {
        int result = 0;
        for (live_data_e index : live_data_e2.values()) {
            if (index.ordinal() >= live_data_e2.ordinal()) continue;
            result += StateDictionary.getSize(this.getFields(index));
        }
        return result;
    }

    private void register(live_data_e ldsIndex, Field[] values, String fileName) {
        this.map.put(ldsIndex, values);
        this.fileNames.put(ldsIndex, fileName);
    }

    @NotNull
    public String getFileName(live_data_e ldsIndex) {
        String result = this.fileNames.get((Object)ldsIndex);
        if (result == null) {
            throw new IllegalStateException("Nothing for " + (Object)((Object)ldsIndex));
        }
        return result;
    }

    @NotNull
    public Field[] getFields(live_data_e ldsIndex) {
        Field[] result = this.map.get((Object)ldsIndex);
        if (result == null) {
            throw new IllegalStateException("Nothing for " + (Object)((Object)ldsIndex));
        }
        return result;
    }
}

