/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.newparse.layout;

import com.rusefi.newparse.layout.EnumLayout;
import com.rusefi.newparse.layout.Layout;
import com.rusefi.newparse.layout.ScalarLayout;
import com.rusefi.newparse.layout.StringLayout;
import com.rusefi.newparse.layout.StructLayout;
import com.rusefi.newparse.layout.StructNamePrefixer;
import com.rusefi.newparse.outputs.TsMetadata;
import com.rusefi.newparse.parsing.EnumField;
import com.rusefi.newparse.parsing.PrototypeField;
import com.rusefi.newparse.parsing.ScalarField;
import com.rusefi.newparse.parsing.StringField;
import com.rusefi.newparse.parsing.StructField;
import java.io.PrintStream;

public class ArrayLayout
extends Layout {
    protected final int[] length;
    protected final Layout prototypeLayout;

    public ArrayLayout(PrototypeField prototype, int[] length) {
        this.length = length;
        if (prototype instanceof ScalarField) {
            this.prototypeLayout = new ScalarLayout((ScalarField)prototype);
        } else if (prototype instanceof EnumField) {
            this.prototypeLayout = new EnumLayout((EnumField)prototype);
        } else if (prototype instanceof StringField) {
            this.prototypeLayout = new StringLayout((StringField)prototype);
        } else if (prototype instanceof StructField) {
            StructField structPrototype = (StructField)prototype;
            this.prototypeLayout = new StructLayout(0, prototype.name, structPrototype.struct);
        } else {
            throw new RuntimeException("unexpected field type during array layout");
        }
    }

    @Override
    public int getSize() {
        int size = this.prototypeLayout.getSize();
        for (int x : this.length) {
            size *= x;
        }
        return size;
    }

    @Override
    public int getAlignment() {
        return this.prototypeLayout.getAlignment();
    }

    @Override
    public void setOffset(int offset) {
        super.setOffset(offset);
        this.prototypeLayout.setOffset(offset);
    }

    @Override
    public void setOffsetWithinStruct(int offset) {
        super.setOffsetWithinStruct(offset);
        this.prototypeLayout.setOffsetWithinStruct(offset);
    }

    @Override
    public String toString() {
        return "Array of " + this.prototypeLayout + " length " + this.length[0] + " " + super.toString();
    }

    @Override
    protected void writeTunerstudioLayout(PrintStream ps, TsMetadata meta, StructNamePrefixer prefixer, int offsetAdd) {
        this.prototypeLayout.writeTunerstudioLayout(ps, meta, prefixer, offsetAdd, this.length);
    }

    @Override
    public void writeCLayout(PrintStream ps) {
        if (this.length[0] > 0) {
            this.prototypeLayout.writeCLayout(ps, this.length);
        }
    }

    @Override
    protected void writeOutputChannelLayout(PrintStream ps, StructNamePrefixer prefixer, int offsetAdd) {
        this.prototypeLayout.writeOutputChannelLayout(ps, prefixer, offsetAdd, this.length);
    }
}

