/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.models.test;

import java.util.ArrayList;
import java.util.Random;

public class SoftLimiterSandbox {
    private Random r = new Random();

    public static void main(String[] args) {
        new SoftLimiterSandbox().testSoftLimit();
    }

    public void testSoftLimit() {
        double targetMissRatio = 0.3;
        int windowSize = 50;
        State state = new State(windowSize);
        System.out.println("Target miss ratio: " + targetMissRatio);
        System.out.println("Window length: " + windowSize);
        System.out.println("eventIndex,state,currentWindowDeepRatio");
        for (int i = 0; i < 250 * windowSize; ++i) {
            state.add(targetMissRatio);
            System.out.println(i + "," + state.getLatest() + "," + state.getCurrentRatio());
        }
    }

    class State {
        private final int windowSize;
        ArrayList<Boolean> states = new ArrayList();

        public State(int windowSize) {
            this.windowSize = windowSize;
            this.states.add(false);
        }

        boolean getLatest() {
            return this.states.get(this.states.size() - 1);
        }

        double getCurrentRatio() {
            int from = Math.max(0, this.states.size() - this.windowSize);
            int count = 0;
            for (int i = from; i < this.states.size(); ++i) {
                if (!this.states.get(i).booleanValue()) continue;
                ++count;
            }
            return (double)count * 1.0 / (double)this.windowSize;
        }

        public void add(double targetMissRatio) {
            if (!this.getLatest()) {
                this.states.add(true);
            } else {
                double currentRatio = this.getCurrentRatio();
                boolean newState = SoftLimiterSandbox.this.r.nextDouble() > 2.0 * targetMissRatio;
                this.states.add(newState);
            }
        }
    }
}

