/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.binaryprotocol.test;

import com.rusefi.autodetect.PortDetector;
import com.rusefi.autodetect.SerialAutoChecker;
import com.rusefi.io.HeartBeatListeners;
import com.rusefi.io.LinkManager;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class SerialSandbox {
    public static void main(String[] args) {
        boolean textPull = false;
        long startTime = System.currentTimeMillis();
        SerialAutoChecker.AutoDetectResult autoDetectResult = PortDetector.autoDetectSerial(callbackContext -> null);
        String port = autoDetectResult.getSerialPort();
        System.out.println("Serial detected on " + port);
        HeartBeatListeners.INSTANCE.addListener(() -> {
            int seconds = (int)((System.currentTimeMillis() - startTime) / 1000L);
            System.out.println(new Date() + ": onDataArrival alive for " + seconds + " second(s) textPull=" + textPull + " " + autoDetectResult.getSignature());
        });
        LinkManager linkManager = new LinkManager().setNeedPullText(textPull).setNeedPullLiveData(true);
        try {
            linkManager.connect(port).await(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Not connected in time");
        }
    }
}

